/*
 * Decompiled with CFR 0.152.
 */
package za.ac.mandela.wrpv301.Controllers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Scanner;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import za.ac.mandela.wrpv301.IO.TextFileQuery;
import za.ac.mandela.wrpv301.IO.XMLQuery;
import za.ac.mandela.wrpv301.Models.Area;
import za.ac.mandela.wrpv301.Models.Item;
import za.ac.mandela.wrpv301.Models.Monster;

public class ForestVentureController {
    private final ArrayList<Area> areas;
    private final ArrayList<Monster> monsters;
    private final ArrayList<Item> items;
    private final boolean[][] positionsVisited;
    private final boolean[] showLines;
    private final boolean[] commands;
    private boolean canEndGame;
    private String direction;
    private final int[][] positions;
    private int row;
    private int column;
    private int initialPosition;
    private final Tooltip[] areaTooltips;
    private final Tooltip[] inventoryTooltips;
    private Label lblGameHeading;
    private HBox menuBox;
    private VBox mainRoot;
    Button btnStartGame;
    Button btnLoadGame;
    Button btnAbout;
    private Label lblAboutHeading;
    private Label lblAboutGame;
    private Label lblCommandsInfo;
    private Label lblPlagiarism;
    private Label lblCreator;
    private BorderPane aboutRoot;
    private VBox commandInfoBox;
    private BorderPane gameRoot;
    private VBox centerBox;
    private VBox inventoryBox;
    private Label lblInventoryHeading;
    private Label lblMoth;
    private Label lblOrb;
    private Label lblSilk;
    private Label lblForkedStick;
    private Label lblKettie;
    private Label lblMarble;
    private Label lblHeading;
    private Label lblStatus;
    private VBox optionsBox;
    private HBox commandBox;
    private Label lblCommandInfo;
    private TextField txtCommand;
    private Button btnEnterCommand;
    private TextArea txaDescription;
    private GridPane mapPane;
    private VBox mapImageBox;
    private Circle friendPosition;
    private final Rectangle[] rectangles = new Rectangle[20];
    private Button btnSaveGame;
    private final Rectangle[] lines = new Rectangle[67];
    private ImageView player;
    private ImageView home;

    public ForestVentureController() {
        int i;
        this.areas = new ArrayList();
        this.monsters = new ArrayList();
        this.items = new ArrayList();
        this.setupAreaFile();
        this.setupMonsterFile();
        this.setupItemFile();
        this.areaTooltips = new Tooltip[20];
        for (i = 0; i <= this.areaTooltips.length - 1; ++i) {
            this.areaTooltips[i] = new Tooltip();
            this.areaTooltips[i].setText(this.areas.get(i).getAreaHeading());
        }
        this.inventoryTooltips = new Tooltip[6];
        for (i = 0; i <= this.inventoryTooltips.length - 1; ++i) {
            this.inventoryTooltips[i] = new Tooltip();
            this.inventoryTooltips[i].setText(this.items.get(i).getItemDescription());
        }
        this.positionsVisited = new boolean[7][7];
        this.commands = new boolean[18];
        this.showLines = new boolean[67];
        this.canEndGame = false;
        this.direction = "";
        this.positions = new int[7][7];
        this.initialPosition = 0;
        this.row = 0;
        this.column = 0;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public boolean getCanEndGame() {
        return this.canEndGame;
    }

    public void setCanEndGame(boolean canEndGame) {
        this.canEndGame = canEndGame;
    }

    private void setInitialPosition(int position) {
        this.initialPosition = position;
    }

    private int getInitialPosition() {
        return this.initialPosition;
    }

    private int getNumberOfItemsInInventory() {
        int totItems = this.items.size();
        if (!this.lblMoth.isVisible()) {
            --totItems;
        }
        if (!this.lblOrb.isVisible()) {
            --totItems;
        }
        if (!this.lblSilk.isVisible()) {
            --totItems;
        }
        if (!this.lblForkedStick.isVisible()) {
            --totItems;
        }
        if (!this.lblKettie.isVisible()) {
            --totItems;
        }
        if (!this.lblMarble.isVisible()) {
            --totItems;
        }
        return totItems;
    }

    public void connectToStartScene(Scene startScene, Scene gameScene, Scene aboutScene, Stage aboutStage, Stage gameStage, Stage primaryStage) {
        this.mainRoot = (VBox)startScene.lookup("#mainRoot");
        this.lblGameHeading = (Label)startScene.lookup("#lblGameHeading");
        this.menuBox = (HBox)startScene.lookup("#menuBox");
        this.btnStartGame = (Button)startScene.lookup("#btnStartGame");
        this.btnLoadGame = (Button)startScene.lookup("#btnLoadGame");
        this.btnAbout = (Button)startScene.lookup("#btnAbout");
        this.setStartStyles();
        this.btnStartGame.setOnAction(event -> {
            gameStage.setScene(gameScene);
            gameStage.setMaximized(true);
            gameStage.show();
            primaryStage.close();
            try {
                this.setArea(0, this.getInitialPosition(), true, false, false);
                this.mapPane.getChildren().remove((Object)this.player);
                this.row = 6;
                this.column = 1;
                this.setupInitialArea();
                FileInputStream inputStream = new FileInputStream("ForestVenture/images/player_north.png");
                Image image = new Image((InputStream)inputStream);
                this.player.setImage(image);
                this.mapPane.add((Node)this.player, this.column, this.row);
                this.mapPane.getChildren().remove((Object)this.home);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        });
        this.btnLoadGame.setOnAction(event -> {
            this.loadGame();
            gameStage.setScene(gameScene);
            gameStage.setMaximized(true);
            gameStage.show();
            primaryStage.close();
            boolean canSearch = this.commands[4];
            boolean keepStatus = false;
            if (!this.lblStatus.getText().equals("")) {
                keepStatus = true;
            }
            this.setArea(0, this.getInitialPosition(), true, false, keepStatus);
            this.setupInitialArea();
            this.commands[4] = canSearch;
            if (this.getCanEndGame() || !this.positionsVisited[1][4]) {
                this.mapPane.getChildren().remove((Object)this.home);
            }
        });
        this.btnAbout.setOnAction(event -> {
            aboutStage.setScene(aboutScene);
            aboutStage.setMaximized(true);
            aboutStage.show();
        });
    }

    private void setStartStyles() {
        this.lblGameHeading.setStyle("-fx-font-family: verdana; -fx-font-size: 30; -fx-text-fill: white; -fx-font-weight: bold;");
        this.menuBox.setSpacing(10.0);
        this.menuBox.setAlignment(Pos.CENTER);
        this.mainRoot.setAlignment(Pos.CENTER);
        BorderPane.setAlignment((Node)this.mainRoot, (Pos)Pos.CENTER);
        this.btnStartGame.setStyle("-fx-font-family: verdana;");
        this.btnStartGame.setFocusTraversable(false);
        this.btnLoadGame.setStyle("-fx-font-family: verdana;");
        this.btnLoadGame.setFocusTraversable(false);
        this.btnAbout.setStyle("-fx-font-family: verdana;");
        this.btnAbout.setFocusTraversable(false);
    }

    public void connectToAboutScene(Scene aboutScene) {
        this.lblAboutHeading = (Label)aboutScene.lookup("#lblAboutHeading");
        this.lblAboutGame = (Label)aboutScene.lookup("#lblAboutGame");
        this.lblCommandsInfo = (Label)aboutScene.lookup("#lblCommandsInfo");
        this.lblPlagiarism = (Label)aboutScene.lookup("#lblPlagiarism");
        this.lblCreator = (Label)aboutScene.lookup("#lblCreator");
        this.aboutRoot = (BorderPane)aboutScene.lookup("#aboutRoot");
        this.commandInfoBox = (VBox)aboutScene.lookup("#commandInfoBox");
        this.setAboutStyles();
    }

    private void setAboutStyles() {
        this.lblAboutHeading.setStyle("-fx-font-family: verdana; -fx-font-size: 16; -fx-text-fill: white;");
        this.lblAboutHeading.setText("About");
        this.lblAboutHeading.setAlignment(Pos.CENTER);
        this.lblAboutGame.setStyle("-fx-font-family: verdana; -fx-font-size: 12; -fx-text-fill: white;");
        this.lblAboutGame.setText("About this game:\nThis game is about a child, that is on a quest to find his friend.\nTo do so, he needs to walk through and search through an enchanted forest. \nThis is the only place left where his friend can be. While walking through\nthe forest, he encounters mysterious monsters. He needs to find ways\nto interact with the monsters if he wishes to succeed in finding his friend.\nAlong the way, he might find places that he can search and maybe find items\nthat will help him. There are also marbles scattered through the forest.\nThese have been accidentally dropped by his friend, but they might come\nin handy now.");
        this.lblCommandsInfo.setStyle("-fx-font-family: verdana; -fx-font-size: 12; -fx-text-fill: white;");
        this.lblCommandsInfo.setAlignment(Pos.CENTER);
        this.lblCommandsInfo.setText("All possible commands:\nmove north/north/n     :   to move north.\nmove west/west/w       :   to move west.\nmove east/east/e       :   to move east.\nmove south/south/s     :   to move south.\nsearch                 :   to search and pick up any items found in the area.\nhide                   :   to hide from monsters.\ngive moth              :   to give a moth to one of the monsters.\ngive orb               :   to give an orb to one of the monsters.\nuse kettie             :   to use the kettie with a marble to stun a monster.\ncraft item             :   to craft an item using items from your inventory.\ncatch moth             :   to catch a moth and add it to your inventory.\nfetch friend           :   to save your friend and complete the game.\ndrop moth              :   to drop a moth from your inventory.\ndrop orb               :   to drop an orb from your inventory.\ndrop silk              :   to drop silk from your inventory.\ndrop stick             :   to drop a forked stick from your inventory.\ndrop kettie            :   to drop a kettie from your inventory.\ndrop marble            :   to drop a marble from your inventory.\nhelp                   :   The help command will open this page.");
        this.lblPlagiarism.setStyle("-fx-font-family: verdana; -fx-font-size: 12; -fx-text-fill: white;");
        this.lblPlagiarism.setText("Please note that none of the images or sounds used in this game are my own.");
        this.lblCreator.setStyle("-fx-font-family: verdana; -fx-font-size: 12; -fx-text-fill: white;");
        this.lblCreator.setText("Game created by Seth de Kock 217191363");
        BorderPane.setAlignment((Node)this.aboutRoot.getTop(), (Pos)Pos.CENTER);
        BorderPane.setAlignment((Node)this.aboutRoot.getBottom(), (Pos)Pos.CENTER);
        this.commandInfoBox.setAlignment(Pos.CENTER);
        this.commandInfoBox.setSpacing(20.0);
    }

    public void connectToGameScene(Stage primaryStage, Stage gameStage, Stage aboutStage, Scene primaryScene, Scene gameScene, Scene aboutScene) {
        int i;
        this.gameRoot = (BorderPane)gameScene.lookup("#gameRoot");
        this.centerBox = (VBox)gameScene.lookup("#centerBox");
        this.lblInventoryHeading = (Label)gameScene.lookup("#lblInventoryHeading");
        this.lblMoth = (Label)gameScene.lookup("#lblMoth");
        this.lblOrb = (Label)gameScene.lookup("#lblOrb");
        this.lblSilk = (Label)gameScene.lookup("#lblSilk");
        this.lblForkedStick = (Label)gameScene.lookup("#lblForkedStick");
        this.lblKettie = (Label)gameScene.lookup("#lblKettie");
        this.lblMarble = (Label)gameScene.lookup("#lblMarble");
        this.inventoryBox = (VBox)gameScene.lookup("#inventoryBox");
        this.optionsBox = (VBox)gameScene.lookup("#optionsBox");
        this.commandBox = (HBox)gameScene.lookup("#commandBox");
        this.lblCommandInfo = (Label)gameScene.lookup("#lblCommandInfo");
        this.txtCommand = (TextField)gameScene.lookup("#txtCommand");
        this.btnEnterCommand = (Button)gameScene.lookup("#btnEnterCommand");
        this.txaDescription = (TextArea)gameScene.lookup("#txaDescription");
        this.lblHeading = (Label)gameScene.lookup("#lblHeading");
        this.mapPane = (GridPane)gameScene.lookup("#mapPane");
        this.mapImageBox = (VBox)gameScene.lookup("#mapImageBox");
        this.friendPosition = (Circle)gameScene.lookup("#friendPosition");
        this.lblStatus = (Label)gameScene.lookup("#lblStatus");
        for (i = 0; i < 20; ++i) {
            this.rectangles[i] = (Rectangle)gameScene.lookup("#" + (i + 1));
        }
        for (i = 0; i <= this.lines.length - 1; ++i) {
            this.lines[i] = (Rectangle)gameScene.lookup("#line" + i);
        }
        this.btnSaveGame = (Button)gameScene.lookup("#btnSaveGame");
        this.player = (ImageView)gameScene.lookup("#player");
        this.home = (ImageView)gameScene.lookup("#home");
        this.setLabelTooltips();
        this.setBindings();
        this.setGameStyles();
        this.setupPositions();
        this.setupInventory();
        this.setGameActions(primaryStage, gameStage, aboutStage, primaryScene, aboutScene);
    }

    private void setupInitialArea() {
        this.rectangles[this.getInitialPosition()].setStyle("-fx-fill: lightgreen");
        Tooltip.install((Node)this.rectangles[this.getInitialPosition()], (Tooltip)this.areaTooltips[this.getInitialPosition()]);
        this.positionsVisited[this.row][this.column] = true;
    }

    private void setLabelTooltips() {
        Tooltip.install((Node)this.lblMoth, (Tooltip)this.inventoryTooltips[0]);
        Tooltip.install((Node)this.lblOrb, (Tooltip)this.inventoryTooltips[1]);
        Tooltip.install((Node)this.lblSilk, (Tooltip)this.inventoryTooltips[2]);
        Tooltip.install((Node)this.lblForkedStick, (Tooltip)this.inventoryTooltips[3]);
        Tooltip.install((Node)this.lblKettie, (Tooltip)this.inventoryTooltips[4]);
        Tooltip.install((Node)this.lblMarble, (Tooltip)this.inventoryTooltips[5]);
    }

    private void setBindings() {
        this.lblMoth.managedProperty().bind((ObservableValue)this.lblMoth.visibleProperty());
        this.lblOrb.managedProperty().bind((ObservableValue)this.lblOrb.visibleProperty());
        this.lblSilk.managedProperty().bind((ObservableValue)this.lblSilk.visibleProperty());
        this.lblForkedStick.managedProperty().bind((ObservableValue)this.lblForkedStick.visibleProperty());
        this.lblKettie.managedProperty().bind((ObservableValue)this.lblKettie.visibleProperty());
        this.lblMarble.managedProperty().bind((ObservableValue)this.lblMarble.visibleProperty());
        this.lblStatus.managedProperty().bind((ObservableValue)this.lblStatus.visibleProperty());
    }

    private void setGameStyles() {
        BorderPane.setAlignment((Node)this.gameRoot.getBottom(), (Pos)Pos.CENTER);
        BorderPane.setAlignment((Node)this.gameRoot.getTop(), (Pos)Pos.CENTER);
        this.centerBox.setAlignment(Pos.CENTER_LEFT);
        this.centerBox.setPadding(new Insets(10.0, 10.0, 10.0, 250.0));
        this.centerBox.setSpacing(20.0);
        this.txaDescription.setStyle("-fx-font-family: verdana; -fx-font-size: 16; -fx-text-fill: black; text-area-background: grey");
        this.txaDescription.setPrefHeight(400.0);
        this.txaDescription.setMaxWidth(700.0);
        BorderPane.setAlignment((Node)this.txaDescription, (Pos)Pos.CENTER);
        this.lblHeading.setStyle("-fx-font-family: verdana; -fx-font-size: 16; -fx-text-fill: white;");
        this.lblHeading.setText("Forest Venture");
        this.lblHeading.setAlignment(Pos.CENTER);
        this.inventoryBox.setPadding(new Insets(50.0, 10.0, 10.0, 10.0));
        this.lblInventoryHeading.setStyle("-fx-font-family: verdana; -fx-font-size: 16; -fx-text-fill: white;");
        this.lblInventoryHeading.setText("Inventory");
        this.lblMoth.setStyle("-fx-font-family: verdana; -fx-font-size: 14; -fx-text-fill: white;");
        this.lblOrb.setStyle("-fx-font-family: verdana; -fx-font-size: 14; -fx-text-fill: white;");
        this.lblSilk.setStyle("-fx-font-family: verdana; -fx-font-size: 14; -fx-text-fill: white;");
        this.lblForkedStick.setStyle("-fx-font-family: verdana; -fx-font-size: 14; -fx-text-fill: white;");
        this.lblKettie.setStyle("-fx-font-family: verdana; -fx-font-size: 14; -fx-text-fill: white;");
        this.lblMarble.setStyle("-fx-font-family: verdana; -fx-font-size: 14; -fx-text-fill: white;");
        this.lblStatus.setStyle("-fx-font-family: verdana; -fx-font-size: 14; -fx-text-fill: lightblue;");
        this.friendPosition.setRadius(2.0);
        this.friendPosition.setStyle("-fx-fill: #515151");
        GridPane.setValignment((Node)this.friendPosition, (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)this.friendPosition, (HPos)HPos.LEFT);
        this.optionsBox.setSpacing(5.0);
        this.optionsBox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.optionsBox.setMinWidth(50.0);
        this.optionsBox.setAlignment(Pos.CENTER);
        this.commandBox.setSpacing(5.0);
        this.commandBox.setAlignment(Pos.CENTER);
        this.txtCommand.setPromptText("Type 'help' for a list of commands");
        this.txtCommand.setMaxWidth(400.0);
        this.txtCommand.setPrefWidth(400.0);
        this.lblCommandInfo.setStyle("-fx-font-family: verdana; -fx-font-size: 12; -fx-text-fill: white;");
        this.lblCommandInfo.setText("Type your command down below, then press enter or click on the enter command button");
        this.btnEnterCommand.setMaxWidth(100.0);
        this.btnEnterCommand.setText("Enter Command");
        this.btnSaveGame.setText("Save Game");
        this.mapImageBox.setSpacing(20.0);
        this.mapImageBox.setPadding(new Insets(50.0, 10.0, 10.0, 10.0));
        GridPane.setHalignment((Node)this.player, (HPos)HPos.CENTER);
        GridPane.setHalignment((Node)this.home, (HPos)HPos.LEFT);
        GridPane.setValignment((Node)this.home, (VPos)VPos.BOTTOM);
        for (int i = 0; i <= this.lines.length - 1; ++i) {
            this.lines[i].setStyle("-fx-fill: #515151");
        }
    }

    private void setupPositions() {
        if (this.positionsVisited[1][4]) {
            this.mapPane.add((Node)this.home, 4, 1);
            GridPane.setHalignment((Node)this.home, (HPos)HPos.LEFT);
            GridPane.setValignment((Node)this.home, (VPos)VPos.BOTTOM);
        }
        this.positions[6][1] = 1;
        this.positions[5][1] = 2;
        this.positions[4][1] = 3;
        this.positions[5][2] = 4;
        this.positions[4][2] = 5;
        this.positions[3][1] = 6;
        this.positions[4][3] = 7;
        this.positions[3][0] = 8;
        this.positions[4][4] = 9;
        this.positions[4][5] = 10;
        this.positions[3][3] = 11;
        this.positions[1][2] = 12;
        this.positions[1][3] = 13;
        this.positions[0][3] = 14;
        this.positions[0][4] = 15;
        this.positions[1][4] = 16;
        this.positions[5][6] = 17;
        this.positions[5][5] = 18;
        this.positions[5][4] = 19;
        this.positions[5][3] = 20;
    }

    private void setupInventory() {
        this.lblMoth.setText(this.items.get(0).getItemName());
        this.lblOrb.setText(this.items.get(1).getItemName());
        this.lblSilk.setText(this.items.get(2).getItemName());
        this.lblForkedStick.setText(this.items.get(3).getItemName());
        this.lblKettie.setText(this.items.get(4).getItemName());
        this.lblMarble.setText(this.items.get(5).getItemName());
        this.lblMoth.setVisible(false);
        this.lblOrb.setVisible(false);
        this.lblSilk.setVisible(false);
        this.lblForkedStick.setVisible(false);
        this.lblKettie.setVisible(false);
        this.lblMarble.setVisible(false);
    }

    private void setArea(int prev, int position, boolean safeFromMonsters, boolean north, boolean keepStatus) {
        String[] curOptions;
        if (position == 0 && prev == 18) {
            this.doLoop(44, 49);
        }
        if (position == 1) {
            if (prev == 0) {
                this.doLoop(0, 1);
            }
            if (prev == 2) {
                this.doLoop(2, 3);
            }
            if (prev == 3) {
                this.doLoop(8, 9);
            }
        }
        if (position == 2) {
            if (prev == 1) {
                this.doLoop(2, 3);
            }
            if (prev == 5) {
                this.doLoop(4, 5);
            }
        }
        if (position == 5) {
            if (prev == 2) {
                this.doLoop(4, 5);
            }
            if (prev == 7) {
                this.doLoop(6, 7);
            }
        }
        if (position == 7) {
            if (prev == 5) {
                this.doLoop(6, 7);
            }
            if (prev == 11) {
                this.doLoop(36, 43);
            }
        }
        if (position == 3) {
            if (prev == 1) {
                this.doLoop(8, 9);
            }
            if (prev == 4) {
                this.doLoop(10, 11);
            }
        }
        if (position == 4) {
            if (prev == 3) {
                this.doLoop(10, 11);
            }
            if (prev == 6) {
                this.doLoop(12, 13);
            }
        }
        if (position == 6) {
            if (prev == 4) {
                this.doLoop(12, 13);
            }
            if (prev == 10) {
                this.doLoop(14, 15);
            }
            if (prev == 8) {
                this.doLoop(16, 17);
            }
        }
        if (position == 10) {
            if (prev == 6) {
                this.doLoop(14, 15);
            }
            if (prev == 12) {
                this.doLoop(64, 66);
            }
        }
        if (position == 8) {
            if (prev == 6) {
                this.doLoop(16, 17);
            }
            if (prev == 18) {
                this.doLoop(18, 19);
            }
            if (prev == 9 && north) {
                this.doLoop(58, 63);
            }
            if (prev == 9 && !north) {
                this.doLoop(22, 23);
            }
        }
        if (position == 18) {
            if (prev == 8) {
                this.doLoop(18, 19);
            }
            if (prev == 19) {
                this.doLoop(20, 21);
            }
            if (prev == 0) {
                this.doLoop(44, 49);
            }
        }
        if (position == 19) {
            this.doLoop(20, 21);
        }
        if (position == 9) {
            if (!north && prev == 8) {
                this.doLoop(22, 23);
            }
            if (prev == 17) {
                this.doLoop(24, 25);
            }
            if (north && prev == 8) {
                this.doLoop(58, 63);
            }
        }
        if (position == 17) {
            if (prev == 9) {
                this.doLoop(24, 25);
            }
            if (prev == 16) {
                this.doLoop(26, 27);
            }
        }
        if (position == 16) {
            if (prev == 17) {
                this.doLoop(26, 27);
            }
            if (prev == 15) {
                this.doLoop(50, 57);
            }
        }
        if (position == 12) {
            if (prev == 11) {
                this.doLoop(28, 29);
            }
            if (prev == 13) {
                this.doLoop(30, 31);
            }
            if (prev == 10) {
                this.doLoop(64, 66);
            }
        }
        if (position == 13) {
            if (prev == 12) {
                this.doLoop(30, 31);
            }
            if (prev == 14) {
                this.doLoop(32, 33);
            }
        }
        if (position == 14) {
            if (prev == 13) {
                this.doLoop(32, 33);
            }
            if (prev == 15) {
                this.doLoop(34, 35);
            }
        }
        if (position == 15) {
            if (prev == 14) {
                this.doLoop(34, 35);
            }
            if (prev == 16) {
                this.doLoop(50, 57);
            }
        }
        if (position == 11) {
            if (prev == 7) {
                this.doLoop(36, 43);
            }
            if (prev == 12) {
                this.doLoop(28, 29);
            }
        }
        double random = 1.0;
        int monsterNumber = -1;
        if (!safeFromMonsters && position != 0 && position != 15) {
            random = this.getRandomNumber(15.0);
        }
        switch ((int)random) {
            case 3: {
                String spiderFile = "spider.mp3";
                Media spiderSound = new Media(new File(spiderFile).toURI().toString());
                MediaPlayer spiderPlayer = new MediaPlayer(spiderSound);
                spiderPlayer.play();
                this.txaDescription.setText(this.monsters.get(0).getMonsterDescription());
                FileInputStream inputStreamSpider = null;
                try {
                    inputStreamSpider = new FileInputStream("ForestVenture/images/giant_Spider.png");
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                assert (inputStreamSpider != null);
                Image imageSpider = new Image((InputStream)inputStreamSpider);
                ImageView imageViewSpider = new ImageView(imageSpider);
                imageViewSpider.setFitHeight(280.0);
                imageViewSpider.setFitWidth(280.0);
                if (this.mapImageBox.getChildren().size() > 1) {
                    this.mapImageBox.getChildren().remove(1);
                }
                this.mapImageBox.getChildren().add((Object)imageViewSpider);
                monsterNumber = 0;
                break;
            }
            case 6: {
                String wizardFile = "wizard.mp3";
                Media wizardSound = new Media(new File(wizardFile).toURI().toString());
                MediaPlayer wizardPlayer = new MediaPlayer(wizardSound);
                wizardPlayer.play();
                this.txaDescription.setText(this.monsters.get(1).getMonsterDescription());
                FileInputStream inputStreamWizard = null;
                try {
                    inputStreamWizard = new FileInputStream("ForestVenture/images/wizard.jpg");
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                assert (inputStreamWizard != null);
                Image imageWizard = new Image((InputStream)inputStreamWizard);
                ImageView imageViewWizard = new ImageView(imageWizard);
                imageViewWizard.setFitHeight(280.0);
                imageViewWizard.setFitWidth(280.0);
                if (this.mapImageBox.getChildren().size() > 1) {
                    this.mapImageBox.getChildren().remove(1);
                }
                this.mapImageBox.getChildren().add((Object)imageViewWizard);
                monsterNumber = 1;
                break;
            }
            case 9: {
                String orcFile = "orc.mp3";
                Media orcSound = new Media(new File(orcFile).toURI().toString());
                MediaPlayer orcPlayer = new MediaPlayer(orcSound);
                orcPlayer.play();
                this.txaDescription.setText(this.monsters.get(2).getMonsterDescription());
                FileInputStream inputStreamOrc = null;
                try {
                    inputStreamOrc = new FileInputStream("ForestVenture/images/orc.jpg");
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                assert (inputStreamOrc != null);
                Image imageOrc = new Image((InputStream)inputStreamOrc);
                ImageView imageViewOrc = new ImageView(imageOrc);
                imageViewOrc.setFitHeight(280.0);
                imageViewOrc.setFitWidth(280.0);
                if (this.mapImageBox.getChildren().size() > 1) {
                    this.mapImageBox.getChildren().remove(1);
                }
                this.mapImageBox.getChildren().add((Object)imageViewOrc);
                monsterNumber = 2;
                break;
            }
            case 12: {
                String witchFile = "witch.mp3";
                Media witchSound = new Media(new File(witchFile).toURI().toString());
                MediaPlayer witchPlayer = new MediaPlayer(witchSound);
                witchPlayer.play();
                this.txaDescription.setText(this.monsters.get(3).getMonsterDescription());
                FileInputStream inputStreamWitch = null;
                try {
                    inputStreamWitch = new FileInputStream("ForestVenture/images/witch.jpg");
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                assert (inputStreamWitch != null);
                Image imageWitch = new Image((InputStream)inputStreamWitch);
                ImageView imageViewWitch = new ImageView(imageWitch);
                imageViewWitch.setFitHeight(280.0);
                imageViewWitch.setFitWidth(280.0);
                if (this.mapImageBox.getChildren().size() > 1) {
                    this.mapImageBox.getChildren().remove(1);
                }
                this.mapImageBox.getChildren().add((Object)imageViewWitch);
                monsterNumber = 3;
                break;
            }
            case 15: {
                String goblinFile = "goblin.mp3";
                Media goblinSound = new Media(new File(goblinFile).toURI().toString());
                MediaPlayer goblinPlayer = new MediaPlayer(goblinSound);
                goblinPlayer.play();
                this.txaDescription.setText(this.monsters.get(4).getMonsterDescription());
                FileInputStream inputStreamGoblin = null;
                try {
                    inputStreamGoblin = new FileInputStream("ForestVenture/images/goblin.jpg");
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                assert (inputStreamGoblin != null);
                Image imageGoblin = new Image((InputStream)inputStreamGoblin);
                ImageView imageViewGoblin = new ImageView(imageGoblin);
                imageViewGoblin.setFitHeight(280.0);
                imageViewGoblin.setFitWidth(280.0);
                if (this.mapImageBox.getChildren().size() > 1) {
                    this.mapImageBox.getChildren().remove(1);
                }
                this.mapImageBox.getChildren().add((Object)imageViewGoblin);
                monsterNumber = 4;
                break;
            }
            default: {
                this.txaDescription.setText(this.areas.get(position).getAreaDescription());
                FileInputStream inputStreamArea = null;
                try {
                    inputStreamArea = new FileInputStream("ForestVenture/images/area" + (position + 1) + ".jpg");
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                assert (inputStreamArea != null);
                Image imageArea = new Image(inputStreamArea);
                ImageView imageViewArea = new ImageView(imageArea);
                imageViewArea.setFitHeight(280.0);
                imageViewArea.setFitWidth(280.0);
                if (this.mapImageBox.getChildren().size() > 1) {
                    this.mapImageBox.getChildren().remove(1);
                }
                this.mapImageBox.getChildren().add((Object)imageViewArea);
            }
        }
        this.disableCommands();
        if (!keepStatus) {
            this.lblStatus.setText("");
        }
        if (monsterNumber == -1) {
            this.commands[12] = true;
            this.commands[13] = true;
            this.commands[14] = true;
            this.commands[15] = true;
            this.commands[16] = true;
            this.commands[17] = true;
            if (this.btnSaveGame.isDisable()) {
                this.btnSaveGame.setDisable(false);
            }
            if (this.items.get(2).getItemPickedUp() && this.items.get(3).getItemPickedUp() && !this.items.get(4).getItemPickedUp()) {
                this.commands[9] = true;
            }
            for (String curOption : curOptions = this.areas.get(position).getOptions()) {
                if (curOption.contains("north")) {
                    this.commands[0] = true;
                    continue;
                }
                if (curOption.contains("west")) {
                    this.commands[1] = true;
                    continue;
                }
                if (curOption.contains("east")) {
                    this.commands[2] = true;
                    continue;
                }
                if (curOption.contains("south")) {
                    this.commands[3] = true;
                    continue;
                }
                if (curOption.contains("Search")) {
                    this.commands[4] = true;
                    continue;
                }
                if (position == 0) {
                    if (!this.items.get(0).getItemPickedUp()) {
                        this.commands[10] = true;
                    }
                    FileInputStream inputStream0 = null;
                    try {
                        inputStream0 = new FileInputStream("ForestVenture/images/area1.jpg");
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    assert (inputStream0 != null);
                    Image image0 = new Image((InputStream)inputStream0);
                    ImageView imageView0 = new ImageView(image0);
                    imageView0.setFitHeight(280.0);
                    imageView0.setFitWidth(280.0);
                    if (this.mapImageBox.getChildren().size() > 1) {
                        this.mapImageBox.getChildren().remove(1);
                    }
                    this.mapImageBox.getChildren().add((Object)imageView0);
                }
                if (position != 15) continue;
                this.mapPane.getChildren().remove((Object)this.home);
                if (this.getCanEndGame()) {
                    this.commands[11] = true;
                    continue;
                }
                this.mapPane.add((Node)this.home, 4, 1);
                GridPane.setHalignment((Node)this.home, (HPos)HPos.LEFT);
                GridPane.setValignment((Node)this.home, (VPos)VPos.BOTTOM);
            }
        } else {
            if (!this.btnSaveGame.isDisable()) {
                this.btnSaveGame.setDisable(true);
            }
            this.disableCommands();
            for (String curOption : curOptions = this.monsters.get(monsterNumber).getOptions()) {
                if (curOption.contains("Hide")) {
                    this.commands[5] = true;
                    continue;
                }
                if (this.items.get(0).getItemPickedUp() && this.lblMoth.isVisible()) {
                    this.commands[6] = true;
                }
                if (this.items.get(1).getItemPickedUp() & this.lblOrb.isVisible()) {
                    this.commands[7] = true;
                }
                if (!this.lblKettie.isVisible() || !this.lblMarble.isVisible()) continue;
                this.commands[8] = true;
            }
        }
    }

    private double getRandomNumber(double maximum) {
        return (double)((int)(Math.random() * (maximum - 1.0 + 1.0))) + 1.0;
    }

    private void doLoop(int start, int end) {
        for (int i = start; i <= end; ++i) {
            this.lines[i].setStyle("-fx-fill: lightgreen");
            this.showLines[i] = true;
        }
    }

    private void disableCommands() {
        for (int i = 0; i <= this.commands.length - 1; ++i) {
            this.commands[i] = false;
        }
    }

    private void moveNorth() {
        this.txtCommand.setText("");
        if (!this.commands[0]) {
            this.lblStatus.setText("Cannot move north now.");
            return;
        }
        this.setDirection("north");
        int current = this.positions[this.row][this.column] - 2;
        if (this.row == 3 && this.column == 0) {
            this.row = 1;
            this.column = 2;
        } else if (this.row == 3 && this.column == 3) {
            this.row = 1;
        } else if (this.row == 4 && this.column == 4) {
            this.setDirection("south");
            this.column = 5;
        } else if (this.row == 5 && this.column == 6) {
            this.setDirection("west");
            this.row = 1;
            this.column = 4;
        } else if (this.row == 4 && this.column == 5) {
            this.setDirection("south");
            this.column = 4;
        } else {
            --this.row;
        }
        for (int x = 0; x < 20; ++x) {
            if (this.positions[this.row][this.column] != x + 1) continue;
            this.rectangles[x].setStyle("-fx-fill: lightgreen");
            Tooltip.install((Node)this.rectangles[x], (Tooltip)this.areaTooltips[x]);
            this.positionsVisited[this.row][this.column] = true;
            FileInputStream inputStream = null;
            try {
                if (this.getDirection().equals("north")) {
                    inputStream = new FileInputStream("ForestVenture/images/player_north.png");
                }
                if (this.getDirection().equals("west")) {
                    inputStream = new FileInputStream("ForestVenture/images/player_west.png");
                }
                if (this.getDirection().equals("south")) {
                    inputStream = new FileInputStream("ForestVenture/images/player_south.png");
                }
                assert (inputStream != null);
                Image image = new Image((InputStream)inputStream);
                this.player.setImage(image);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.mapPane.getChildren().remove((Object)this.player);
            this.mapPane.add((Node)this.player, this.column, this.row);
            this.setArea(current + 1, x, false, true, false);
        }
    }

    private void moveWest() {
        this.txtCommand.setText("");
        if (!this.commands[1]) {
            this.lblStatus.setText("Cannot move west now.");
            return;
        }
        this.setDirection("west");
        int current = this.positions[this.row][this.column] - 2;
        --this.column;
        for (int x = 0; x < 20; ++x) {
            if (this.positions[this.row][this.column] != x + 1) continue;
            this.rectangles[x].setStyle("-fx-fill: lightgreen");
            Tooltip.install((Node)this.rectangles[x], (Tooltip)this.areaTooltips[x]);
            this.positionsVisited[this.row][this.column] = true;
            try {
                FileInputStream inputStream = new FileInputStream("ForestVenture/images/player_west.png");
                Image image = new Image((InputStream)inputStream);
                this.player.setImage(image);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.mapPane.getChildren().remove((Object)this.player);
            this.mapPane.add((Node)this.player, this.column, this.row);
            this.setArea(current + 1, x, false, false, false);
        }
    }

    private void moveEast() {
        this.txtCommand.setText("");
        if (!this.commands[2]) {
            this.lblStatus.setText("Cannot move east now.");
            return;
        }
        this.setDirection("east");
        int current = this.positions[this.row][this.column] - 2;
        if (this.row == 1 && this.column == 4) {
            this.setDirection("south");
            this.row = 5;
            this.column = 6;
        } else if (this.row == 6 && this.column == 1) {
            this.setDirection("north");
            this.row = 5;
            this.column = 4;
        } else {
            ++this.column;
        }
        for (int x = 0; x < 20; ++x) {
            if (this.positions[this.row][this.column] != x + 1) continue;
            this.rectangles[x].setStyle("-fx-fill: lightgreen");
            Tooltip.install((Node)this.rectangles[x], (Tooltip)this.areaTooltips[x]);
            this.positionsVisited[this.row][this.column] = true;
            try {
                FileInputStream inputStream = null;
                if (this.getDirection().equals("east")) {
                    inputStream = new FileInputStream("ForestVenture/images/player_east.png");
                }
                if (this.getDirection().equals("south")) {
                    inputStream = new FileInputStream("ForestVenture/images/player_south.png");
                }
                if (this.getDirection().equals("north")) {
                    inputStream = new FileInputStream("ForestVenture/images/player_north.png");
                }
                assert (inputStream != null);
                Image image = new Image((InputStream)inputStream);
                this.player.setImage(image);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.mapPane.getChildren().remove((Object)this.player);
            this.mapPane.add((Node)this.player, this.column, this.row);
            this.setArea(current + 1, x, false, false, false);
        }
    }

    private void moveSouth() {
        this.txtCommand.setText("");
        if (!this.commands[3]) {
            this.lblStatus.setText("Cannot move south now.");
            return;
        }
        this.setDirection("south");
        int current = this.positions[this.row][this.column] - 2;
        if (this.row == 1 && this.column == 2) {
            this.row = 3;
            this.column = 0;
        } else if (this.row == 1 && this.column == 3) {
            this.row = 3;
            this.column = 3;
        } else if (this.row == 5 && this.column == 4) {
            this.setDirection("west");
            this.row = 6;
            this.column = 1;
        } else {
            ++this.row;
        }
        for (int x = 0; x < 20; ++x) {
            if (this.positions[this.row][this.column] != x + 1) continue;
            this.rectangles[x].setStyle("-fx-fill: lightgreen");
            Tooltip.install((Node)this.rectangles[x], (Tooltip)this.areaTooltips[x]);
            this.positionsVisited[this.row][this.column] = true;
            try {
                FileInputStream inputStream = null;
                if (this.getDirection().equals("south")) {
                    inputStream = new FileInputStream("ForestVenture/images/player_south.png");
                }
                if (this.getDirection().equals("west")) {
                    inputStream = new FileInputStream("ForestVenture/images/player_west.png");
                }
                assert (inputStream != null);
                Image image = new Image((InputStream)inputStream);
                this.player.setImage(image);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.mapPane.getChildren().remove((Object)this.player);
            this.mapPane.add((Node)this.player, this.column, this.row);
            this.setArea(current + 1, x, false, false, false);
        }
    }

    private void search() {
        this.txtCommand.setText("");
        if (!this.commands[4]) {
            this.lblStatus.setText("Cannot search now.");
            return;
        }
        this.commands[4] = false;
        double random = this.getRandomNumber(3.0);
        if (random == 1.0 && !this.items.get(1).getItemPickedUp()) {
            this.lblStatus.setText("You have picked up an orb.");
            this.lblOrb.setVisible(true);
            this.items.get(1).setItemPickedUp(true);
            return;
        }
        if (random == 2.0 && !this.items.get(3).getItemPickedUp()) {
            this.lblStatus.setText("You have picked up a forked stick.");
            this.lblForkedStick.setVisible(true);
            this.items.get(3).setItemPickedUp(true);
            if (this.items.get(2).getItemPickedUp()) {
                this.commands[9] = true;
                this.lblStatus.setText("You have picked up a forked stick. You can now craft a new item.");
            }
            return;
        }
        if (random == 3.0 && !this.items.get(5).getItemPickedUp()) {
            this.lblStatus.setText("You have picked up a marble.");
            this.lblMarble.setVisible(true);
            this.items.get(5).setItemPickedUp(true);
            return;
        }
        this.lblStatus.setText("Nothing was found.");
    }

    private void hide(Stage primaryStage, Scene primaryScene, Stage gameStage) {
        boolean condition;
        this.txtCommand.setText("");
        if (!this.commands[5]) {
            this.lblStatus.setText("You don't need to hide.");
            return;
        }
        int current = this.positions[this.row][this.column] - 2;
        double random = this.getRandomNumber(10.0);
        int modNumber = 3;
        int numberOfItemsCarrying = this.getNumberOfItemsInInventory();
        boolean bl = condition = random % (double)modNumber != 0.0;
        if (numberOfItemsCarrying < 3) {
            random = this.getRandomNumber(10.0);
            boolean bl2 = condition = random % (double)(modNumber = 2) == 0.0;
        }
        if (condition) {
            int i;
            primaryStage.setScene(primaryScene);
            primaryStage.setMaximized(true);
            primaryStage.show();
            this.lblGameHeading.setText("You Have Died!");
            gameStage.close();
            for (Item cur : this.items) {
                cur.setItemPickedUp(false);
            }
            this.lblMoth.setVisible(false);
            this.lblOrb.setVisible(false);
            this.lblSilk.setVisible(false);
            this.lblForkedStick.setVisible(false);
            this.lblKettie.setVisible(false);
            this.lblMarble.setVisible(false);
            for (i = 0; i <= this.rectangles.length - 1; ++i) {
                this.rectangles[i].setStyle("-fx-fill: #515151");
                Tooltip.uninstall((Node)this.rectangles[i], (Tooltip)this.areaTooltips[i]);
            }
            for (i = 0; i <= this.showLines.length - 1; ++i) {
                this.showLines[i] = false;
                this.lines[i].setStyle("-fx-fill: #515151");
            }
            for (i = 0; i < 7; ++i) {
                for (int y = 0; y < 7; ++y) {
                    this.positionsVisited[i][y] = false;
                }
            }
            this.friendPosition.setStyle("-fx-fill: #515151");
            this.commands[11] = false;
            this.setInitialPosition(0);
            this.areas.clear();
            this.setupAreaFile();
            this.setCanEndGame(false);
        } else {
            this.setArea(current + 1, this.positions[this.row][this.column] - 1, true, false, false);
        }
    }

    private void giveMoth(Stage primaryStage, Scene primaryScene, Stage gameStage) {
        this.txtCommand.setText("");
        if (!this.commands[6]) {
            this.lblStatus.setText("You cannot give a moth now.");
            return;
        }
        int current = this.positions[this.row][this.column] - 2;
        if (this.txaDescription.getText().equals(this.monsters.get(0).getMonsterDescription())) {
            this.lblStatus.setText("Thanks for the Snack! Here is some silk in return.");
            this.lblMoth.setVisible(false);
            this.lblSilk.setVisible(true);
            this.items.get(2).setItemPickedUp(true);
            if (this.items.get(3).getItemPickedUp()) {
                this.commands[9] = true;
                this.lblStatus.setText("Thanks for the Snack! Here is some silk in return. You can now craft a new item.");
            }
            this.commands[6] = false;
            this.setArea(current + 1, this.positions[this.row][this.column] - 1, true, false, true);
        } else {
            int i;
            primaryStage.setScene(primaryScene);
            primaryStage.setMaximized(true);
            primaryStage.show();
            this.lblGameHeading.setText("You Have Died!");
            gameStage.close();
            for (Item cur : this.items) {
                cur.setItemPickedUp(false);
            }
            this.lblMoth.setVisible(false);
            this.lblOrb.setVisible(false);
            this.lblSilk.setVisible(false);
            this.lblForkedStick.setVisible(false);
            this.lblKettie.setVisible(false);
            this.lblMarble.setVisible(false);
            for (i = 0; i <= this.rectangles.length - 1; ++i) {
                this.rectangles[i].setStyle("-fx-fill: #515151");
                Tooltip.uninstall((Node)this.rectangles[i], (Tooltip)this.areaTooltips[i]);
            }
            for (i = 0; i <= this.showLines.length - 1; ++i) {
                this.showLines[i] = false;
                this.lines[i].setStyle("-fx-fill: #515151");
            }
            for (i = 0; i < 7; ++i) {
                for (int y = 0; y < 7; ++y) {
                    this.positionsVisited[i][y] = false;
                }
            }
            this.friendPosition.setStyle("-fx-fill: #515151");
            this.commands[11] = false;
            this.setInitialPosition(0);
            this.areas.clear();
            this.setupAreaFile();
            this.setCanEndGame(false);
        }
    }

    private void giveOrb(Stage primaryStage, Scene primaryScene, Stage gameStage) {
        this.txtCommand.setText("");
        if (!this.commands[7]) {
            this.lblStatus.setText("You cannot give an orb now.");
            return;
        }
        int current = this.positions[this.row][this.column] - 2;
        if (this.txaDescription.getText().equals(this.monsters.get(1).getMonsterDescription())) {
            if (this.positionsVisited[1][4]) {
                this.mapPane.getChildren().remove((Object)this.home);
            }
            this.friendPosition.setStyle("-fx-fill: lightblue");
            this.lblStatus.setText("Thanks for the Orb! Let me help you find your friend.");
            this.setArea(current + 1, this.positions[this.row][this.column] - 1, true, false, true);
            this.areas.get(15).setAreaDescription(this.areas.get(this.areas.size() - 2).getAreaDescription());
            this.areaTooltips[15].setText(this.areas.get(this.areas.size() - 2).getAreaHeading());
            this.lblOrb.setVisible(false);
            this.commands[7] = false;
            this.setCanEndGame(true);
        } else {
            int i;
            primaryStage.setScene(primaryScene);
            primaryStage.setMaximized(true);
            primaryStage.show();
            this.lblGameHeading.setText("You Have Died!");
            gameStage.close();
            for (Item cur : this.items) {
                cur.setItemPickedUp(false);
            }
            this.lblMoth.setVisible(false);
            this.lblOrb.setVisible(false);
            this.lblSilk.setVisible(false);
            this.lblForkedStick.setVisible(false);
            this.lblKettie.setVisible(false);
            this.lblMarble.setVisible(false);
            for (i = 0; i <= this.rectangles.length - 1; ++i) {
                this.rectangles[i].setStyle("-fx-fill: #515151");
                Tooltip.uninstall((Node)this.rectangles[i], (Tooltip)this.areaTooltips[i]);
            }
            for (i = 0; i <= this.showLines.length - 1; ++i) {
                this.showLines[i] = false;
                this.lines[i].setStyle("-fx-fill: #515151");
            }
            for (i = 0; i < 7; ++i) {
                for (int y = 0; y < 7; ++y) {
                    this.positionsVisited[i][y] = false;
                }
            }
            this.friendPosition.setStyle("-fx-fill: #515151");
            this.commands[11] = false;
            this.setInitialPosition(0);
            this.areas.clear();
            this.setupAreaFile();
            this.setCanEndGame(false);
        }
    }

    private void useKettie() {
        this.txtCommand.setText("");
        if (!this.commands[8]) {
            this.lblStatus.setText("You cannot currently use the kettie.");
            return;
        }
        int current = this.positions[this.row][this.column] - 2;
        this.lblStatus.setText("The monster has been stunned.");
        this.lblMarble.setVisible(false);
        this.items.get(5).setItemPickedUp(false);
        this.setArea(current + 1, this.positions[this.row][this.column] - 1, true, false, true);
    }

    private void craftItem() {
        this.txtCommand.setText("");
        if (!this.commands[9]) {
            this.lblStatus.setText("You cannot craft an item at this moment.");
            return;
        }
        this.lblStatus.setText("You have crafted a kettie!");
        this.lblKettie.setVisible(true);
        this.items.get(4).setItemPickedUp(true);
        this.lblSilk.setVisible(false);
        this.lblForkedStick.setVisible(false);
        this.commands[9] = false;
    }

    private void catchMoth() {
        this.txtCommand.setText("");
        if (!this.commands[10]) {
            this.lblStatus.setText("There are no moths to catch here.");
            return;
        }
        this.lblStatus.setText("You have caught a moth.");
        this.areas.get(0).setAreaDescription(this.areas.get(this.areas.size() - 1).getAreaDescription());
        this.areaTooltips[0].setText(this.areas.get(this.areas.size() - 1).getAreaHeading());
        this.items.get(0).setItemPickedUp(true);
        this.lblMoth.setVisible(true);
        this.commands[6] = false;
    }

    private void fetchFriend(Stage primaryStage, Scene primaryScene, Stage gameStage) {
        int i;
        this.txtCommand.setText("");
        if (!this.commands[11]) {
            this.lblStatus.setText("Your friend isn't here.");
            return;
        }
        primaryStage.setScene(primaryScene);
        primaryStage.setMaximized(true);
        primaryStage.show();
        this.lblGameHeading.setText("Congratulations, you found your friend!");
        gameStage.close();
        for (Item cur : this.items) {
            cur.setItemPickedUp(false);
        }
        this.lblMoth.setVisible(false);
        this.lblOrb.setVisible(false);
        this.lblSilk.setVisible(false);
        this.lblForkedStick.setVisible(false);
        this.lblKettie.setVisible(false);
        this.lblMarble.setVisible(false);
        for (i = 0; i <= this.rectangles.length - 1; ++i) {
            this.rectangles[i].setStyle("-fx-fill: #515151");
            Tooltip.uninstall((Node)this.rectangles[i], (Tooltip)this.areaTooltips[i]);
        }
        for (i = 0; i <= this.showLines.length - 1; ++i) {
            this.showLines[i] = false;
            this.lines[i].setStyle("-fx-fill: #515151");
        }
        for (i = 0; i < 7; ++i) {
            for (int y = 0; y < 7; ++y) {
                this.positionsVisited[i][y] = false;
            }
        }
        this.friendPosition.setStyle("-fx-fill: #515151");
        this.commands[11] = false;
        this.setInitialPosition(0);
        this.areas.clear();
        this.setupAreaFile();
        this.setCanEndGame(false);
    }

    private void doCommand(Stage primaryStage, Stage gameStage, Stage aboutStage, Scene primaryScene, Scene aboutScene) {
        String commandString = this.txtCommand.getText().toLowerCase();
        if (commandString.equals("move north") || commandString.equals("north") || commandString.equals("n")) {
            this.moveNorth();
            return;
        }
        if (commandString.equals("move west") || commandString.equals("west") || commandString.equals("w")) {
            this.moveWest();
            return;
        }
        if (commandString.equals("move east") || commandString.equals("east") || commandString.equals("e")) {
            this.moveEast();
            return;
        }
        if (commandString.equals("move south") || commandString.equals("south") || commandString.equals("s")) {
            this.moveSouth();
            return;
        }
        if (commandString.equals("search")) {
            this.search();
            return;
        }
        if (commandString.equals("hide")) {
            this.hide(primaryStage, primaryScene, gameStage);
            return;
        }
        if (commandString.equals("give moth")) {
            this.giveMoth(primaryStage, primaryScene, gameStage);
            return;
        }
        if (commandString.equals("give orb")) {
            this.giveOrb(primaryStage, primaryScene, gameStage);
            return;
        }
        if (commandString.equals("use kettie")) {
            this.useKettie();
            return;
        }
        if (commandString.equals("craft item")) {
            this.craftItem();
            return;
        }
        if (commandString.equals("catch moth")) {
            this.catchMoth();
            return;
        }
        if (commandString.equals("fetch friend")) {
            this.fetchFriend(primaryStage, primaryScene, gameStage);
            return;
        }
        if (commandString.equals("drop moth")) {
            this.txtCommand.setText("");
            if (this.lblMoth.isVisible() && this.commands[12]) {
                this.lblMoth.setVisible(false);
                this.items.get(0).setItemPickedUp(false);
                this.lblStatus.setText("You have dropped a moth.");
            } else {
                this.lblStatus.setText("You cannot drop a moth.");
            }
            return;
        }
        if (commandString.equals("drop orb")) {
            this.txtCommand.setText("");
            if (this.lblOrb.isVisible() && this.commands[13]) {
                this.lblOrb.setVisible(false);
                this.items.get(1).setItemPickedUp(false);
                this.lblStatus.setText("You have dropped an orb.");
            } else {
                this.lblStatus.setText("You cannot drop an orb.");
            }
            return;
        }
        if (commandString.equals("drop silk")) {
            this.txtCommand.setText("");
            if (this.lblSilk.isVisible() && this.commands[14]) {
                this.lblSilk.setVisible(false);
                this.items.get(2).setItemPickedUp(false);
                this.lblStatus.setText("You have dropped silk.");
            } else {
                this.lblStatus.setText("You cannot drop silk.");
            }
            return;
        }
        if (commandString.equals("drop stick")) {
            this.txtCommand.setText("");
            if (this.lblForkedStick.isVisible() && this.commands[15]) {
                this.lblForkedStick.setVisible(false);
                this.items.get(3).setItemPickedUp(false);
                this.lblStatus.setText("You have dropped a stick.");
            } else {
                this.lblStatus.setText("You cannot drop a stick.");
            }
            return;
        }
        if (commandString.equals("drop kettie")) {
            this.txtCommand.setText("");
            if (this.lblKettie.isVisible() && this.commands[16]) {
                this.lblKettie.setVisible(false);
                this.items.get(4).setItemPickedUp(false);
                this.lblStatus.setText("You have dropped a kettie.");
            } else {
                this.lblStatus.setText("You cannot drop a kettie.");
            }
            return;
        }
        if (commandString.equals("drop marble")) {
            this.txtCommand.setText("");
            if (this.lblMarble.isVisible() && this.commands[17]) {
                this.lblMarble.setVisible(false);
                this.items.get(5).setItemPickedUp(false);
                this.lblStatus.setText("You have dropped a marble.");
            } else {
                this.lblStatus.setText("You cannot drop a marble.");
            }
            return;
        }
        if (commandString.equals("help")) {
            aboutStage.setScene(aboutScene);
            aboutStage.setMaximized(true);
            aboutStage.show();
            this.txtCommand.setText("");
            return;
        }
        this.lblStatus.setText("This command is not recognised.");
        this.txtCommand.setText("");
    }

    private void setGameActions(Stage primaryStage, Stage gameStage, Stage aboutStage, Scene primaryScene, Scene aboutScene) {
        this.txtCommand.setOnKeyPressed(event -> {
            if (event.getCode().equals((Object)KeyCode.ENTER)) {
                this.doCommand(primaryStage, gameStage, aboutStage, primaryScene, aboutScene);
            }
        });
        this.btnEnterCommand.setOnAction(event -> {
            this.txtCommand.requestFocus();
            this.doCommand(primaryStage, gameStage, aboutStage, primaryScene, aboutScene);
        });
        this.btnSaveGame.setOnAction(event -> {
            this.txtCommand.requestFocus();
            this.saveGame();
        });
    }

    private void setupAreaFile() {
        XMLQuery areaFile = () -> {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = null;
            try {
                db = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            File fin = new File("./ForestVenture/lib/Areas.xml");
            Document doc = null;
            try {
                assert (db != null);
                doc = db.parse(fin);
            }
            catch (IOException | SAXException e) {
                e.printStackTrace();
            }
            assert (doc != null);
            doc.getDocumentElement().normalize();
            XPath xpath = XPathFactory.newInstance().newXPath();
            String areaString = "/areas/area";
            NodeList nodes = null;
            try {
                nodes = (NodeList)xpath.compile(areaString).evaluate(doc, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < Objects.requireNonNull(nodes).getLength(); ++i) {
                org.w3c.dom.Node areaOptions;
                org.w3c.dom.Node areaDescription;
                org.w3c.dom.Node cur = nodes.item(i);
                if (cur.getNodeType() != 1) continue;
                Element curElement = (Element)cur;
                Area newOne = new Area();
                org.w3c.dom.Node areaHeading = curElement.getElementsByTagName("areaHeading").item(0);
                if (areaHeading.getNodeType() == 1) {
                    Element areaHeadingElement = (Element)areaHeading;
                    newOne.setAreaHeading(areaHeadingElement.getTextContent());
                }
                if ((areaDescription = curElement.getElementsByTagName("areaDescription").item(0)).getNodeType() == 1) {
                    Element areaDescriptionElement = (Element)areaDescription;
                    newOne.setAreaDescription(areaDescriptionElement.getTextContent());
                }
                if ((areaOptions = curElement.getElementsByTagName("options").item(0)).getNodeType() == 1) {
                    Element curOptionElement = (Element)areaOptions;
                    NodeList curOption = curOptionElement.getElementsByTagName("option");
                    String[] options = new String[curOption.getLength()];
                    for (int z = 0; z < curOption.getLength(); ++z) {
                        org.w3c.dom.Node optionNode = curOption.item(z);
                        if (optionNode.getNodeType() != 1) continue;
                        Element option = (Element)optionNode;
                        options[z] = option.getTextContent();
                    }
                    newOne.setOptions(options);
                }
                this.areas.add(newOne);
            }
        };
        areaFile.readXMLFile();
    }

    private void setupMonsterFile() {
        XMLQuery monsterFile = () -> {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = null;
            try {
                db = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            File fin = new File("./ForestVenture/lib/Monsters.xml");
            Document doc = null;
            try {
                assert (db != null);
                doc = db.parse(fin);
            }
            catch (IOException | SAXException e) {
                e.printStackTrace();
            }
            assert (doc != null);
            doc.getDocumentElement().normalize();
            XPath xpath = XPathFactory.newInstance().newXPath();
            String areaString = "/monsters/monster";
            NodeList nodes = null;
            try {
                nodes = (NodeList)xpath.compile(areaString).evaluate(doc, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < Objects.requireNonNull(nodes).getLength(); ++i) {
                org.w3c.dom.Node monsterOptions;
                org.w3c.dom.Node monsterDescription;
                org.w3c.dom.Node cur = nodes.item(i);
                if (cur.getNodeType() != 1) continue;
                Element curElement = (Element)cur;
                Monster newOne = new Monster();
                org.w3c.dom.Node monsterName = curElement.getElementsByTagName("name").item(0);
                if (monsterName.getNodeType() == 1) {
                    Element monsterNameElement = (Element)monsterName;
                    newOne.setMonsterName(monsterNameElement.getTextContent());
                }
                if ((monsterDescription = curElement.getElementsByTagName("description").item(0)).getNodeType() == 1) {
                    Element monsterDescriptionElement = (Element)monsterDescription;
                    newOne.setMonsterDescription(monsterDescriptionElement.getTextContent());
                }
                if ((monsterOptions = curElement.getElementsByTagName("options").item(0)).getNodeType() == 1) {
                    Element curOptionElement = (Element)monsterOptions;
                    NodeList curOption = curOptionElement.getElementsByTagName("option");
                    String[] options = new String[curOption.getLength()];
                    for (int z = 0; z < curOption.getLength(); ++z) {
                        org.w3c.dom.Node optionNode = curOption.item(z);
                        if (optionNode.getNodeType() != 1) continue;
                        Element option = (Element)optionNode;
                        options[z] = option.getTextContent();
                    }
                    newOne.setOptions(options);
                }
                this.monsters.add(newOne);
            }
        };
        monsterFile.readXMLFile();
    }

    private void setupItemFile() {
        XMLQuery itemFile = () -> {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = null;
            try {
                db = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            File fin = new File("./ForestVenture/lib/Items.xml");
            Document doc = null;
            try {
                assert (db != null);
                doc = db.parse(fin);
            }
            catch (IOException | SAXException e) {
                e.printStackTrace();
            }
            assert (doc != null);
            doc.getDocumentElement().normalize();
            XPath xpath = XPathFactory.newInstance().newXPath();
            String areaString = "/items/item";
            NodeList nodes = null;
            try {
                nodes = (NodeList)xpath.compile(areaString).evaluate(doc, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < Objects.requireNonNull(nodes).getLength(); ++i) {
                org.w3c.dom.Node itemPickedUp;
                org.w3c.dom.Node itemDescription;
                org.w3c.dom.Node cur = nodes.item(i);
                if (cur.getNodeType() != 1) continue;
                Element curElement = (Element)cur;
                Item newOne = new Item();
                org.w3c.dom.Node itemName = curElement.getElementsByTagName("itemName").item(0);
                if (itemName.getNodeType() == 1) {
                    Element itemNameElement = (Element)itemName;
                    newOne.setItemName(itemNameElement.getTextContent());
                }
                if ((itemDescription = curElement.getElementsByTagName("itemDescription").item(0)).getNodeType() == 1) {
                    Element itemDescriptionElement = (Element)itemDescription;
                    newOne.setItemDescription(itemDescriptionElement.getTextContent());
                }
                if ((itemPickedUp = curElement.getElementsByTagName("itemPickedUp").item(0)).getNodeType() == 1) {
                    Element itemPickedUpElement = (Element)itemPickedUp;
                    newOne.setItemPickedUp(Boolean.parseBoolean(itemPickedUpElement.getTextContent()));
                }
                this.items.add(newOne);
            }
        };
        itemFile.readXMLFile();
    }

    private void loadGame() {
        TextFileQuery readGameFile = () -> {
            try {
                String[] line;
                String inventory;
                Image image;
                FileInputStream inputStream;
                FileReader file = new FileReader("./ForestVenture/lib/savedGame.txt");
                Scanner reader = new Scanner(file);
                int position = Integer.parseInt(reader.nextLine());
                this.setInitialPosition(position - 1);
                this.row = Integer.parseInt(reader.nextLine());
                this.column = Integer.parseInt(reader.nextLine());
                String direction = reader.nextLine();
                if (direction.equals("north")) {
                    try {
                        inputStream = new FileInputStream("ForestVenture/images/player_north.png");
                        image = new Image((InputStream)inputStream);
                        this.player.setImage(image);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    this.mapPane.getChildren().remove((Object)this.player);
                    this.mapPane.add((Node)this.player, this.column, this.row);
                    this.setDirection("north");
                }
                if (direction.equals("west")) {
                    try {
                        inputStream = new FileInputStream("ForestVenture/images/player_west.png");
                        image = new Image((InputStream)inputStream);
                        this.player.setImage(image);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    this.mapPane.getChildren().remove((Object)this.player);
                    this.mapPane.add((Node)this.player, this.column, this.row);
                    this.setDirection("west");
                }
                if (direction.equals("east")) {
                    try {
                        inputStream = new FileInputStream("ForestVenture/images/player_east.png");
                        image = new Image((InputStream)inputStream);
                        this.player.setImage(image);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    this.mapPane.getChildren().remove((Object)this.player);
                    this.mapPane.add((Node)this.player, this.column, this.row);
                    this.setDirection("east");
                }
                if (direction.equals("south")) {
                    try {
                        inputStream = new FileInputStream("ForestVenture/images/player_south.png");
                        image = new Image((InputStream)inputStream);
                        this.player.setImage(image);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    this.mapPane.getChildren().remove((Object)this.player);
                    this.mapPane.add((Node)this.player, this.column, this.row);
                    this.setDirection("south");
                }
                if (!(inventory = reader.nextLine()).equals("Empty")) {
                    String[] inventoryItems;
                    for (String cur : inventoryItems = inventory.split(",")) {
                        if (cur.equals(this.lblMoth.getText())) {
                            this.lblMoth.setVisible(true);
                            this.items.get(0).setItemPickedUp(true);
                            this.areas.get(0).setAreaDescription(this.areas.get(this.areas.size() - 1).getAreaDescription());
                            this.areaTooltips[0].setText(this.areas.get(this.areas.size() - 1).getAreaHeading());
                            continue;
                        }
                        if (cur.equals(this.lblOrb.getText())) {
                            this.lblOrb.setVisible(true);
                            this.items.get(1).setItemPickedUp(true);
                            continue;
                        }
                        if (cur.equals(this.lblSilk.getText())) {
                            this.lblSilk.setVisible(true);
                            this.items.get(0).setItemPickedUp(true);
                            this.items.get(2).setItemPickedUp(true);
                            this.areas.get(0).setAreaDescription(this.areas.get(this.areas.size() - 1).getAreaDescription());
                            this.areaTooltips[0].setText(this.areas.get(this.areas.size() - 1).getAreaHeading());
                            continue;
                        }
                        if (cur.equals(this.lblForkedStick.getText())) {
                            this.lblForkedStick.setVisible(true);
                            this.items.get(3).setItemPickedUp(true);
                            continue;
                        }
                        if (cur.equals(this.lblKettie.getText())) {
                            this.lblKettie.setVisible(true);
                            this.items.get(0).setItemPickedUp(true);
                            this.items.get(4).setItemPickedUp(true);
                            this.items.get(2).setItemPickedUp(true);
                            this.items.get(3).setItemPickedUp(true);
                            this.areas.get(0).setAreaDescription(this.areas.get(this.areas.size() - 1).getAreaDescription());
                            this.areaTooltips[0].setText(this.areas.get(this.areas.size() - 1).getAreaHeading());
                            continue;
                        }
                        if (!cur.equals(this.lblMarble.getText())) continue;
                        this.lblMarble.setVisible(true);
                        this.items.get(5).setItemPickedUp(true);
                    }
                }
                String canSearch = reader.nextLine();
                this.commands[4] = Boolean.parseBoolean(canSearch);
                String allLines = reader.nextLine();
                for (String cur : line = allLines.split(",")) {
                    if (cur.equals("")) continue;
                    this.lines[Integer.parseInt(cur)].setStyle("-fx-fill: lightgreen");
                    this.showLines[Integer.parseInt((String)cur)] = true;
                }
                String canEnd = reader.nextLine();
                if (Boolean.parseBoolean(canEnd)) {
                    this.friendPosition.setStyle("-fx-fill: lightblue");
                    this.items.get(1).setItemPickedUp(true);
                    this.areas.get(15).setAreaDescription(this.areas.get(this.areas.size() - 2).getAreaDescription());
                    this.areaTooltips[15].setText(this.areas.get(this.areas.size() - 2).getAreaHeading());
                    this.setCanEndGame(true);
                } else {
                    this.setCanEndGame(false);
                }
                String status = reader.nextLine();
                if (!status.equals("")) {
                    this.lblStatus.setText(status);
                }
                while (reader.hasNextLine()) {
                    String rectanglePosition = reader.nextLine();
                    String[] stringPositions = rectanglePosition.split(",");
                    int positionToAlter = this.positions[Integer.parseInt(stringPositions[0])][Integer.parseInt(stringPositions[1])];
                    this.rectangles[positionToAlter - 1].setStyle("-fx-fill: lightgreen");
                    Tooltip.install((Node)this.rectangles[positionToAlter - 1], (Tooltip)this.areaTooltips[positionToAlter - 1]);
                    this.positionsVisited[Integer.parseInt((String)stringPositions[0])][Integer.parseInt((String)stringPositions[1])] = true;
                }
                reader.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        };
        readGameFile.doQuery();
    }

    private void saveGame() {
        TextFileQuery saveGameFile = () -> {
            try {
                int i;
                FileWriter writer = new FileWriter("./ForestVenture/lib/savedGame.txt");
                BufferedWriter bw = new BufferedWriter(writer);
                bw.write(this.positions[this.row][this.column] + "");
                bw.newLine();
                bw.write(this.row + "");
                bw.newLine();
                bw.write(this.column + "");
                bw.newLine();
                if (this.getDirection().equals("north")) {
                    bw.write("north");
                }
                if (this.getDirection().equals("west")) {
                    bw.write("west");
                }
                if (this.getDirection().equals("east")) {
                    bw.write("east");
                }
                if (this.getDirection().equals("south")) {
                    bw.write("south");
                }
                bw.newLine();
                boolean emptyInventory = true;
                if (this.lblMoth.isVisible()) {
                    emptyInventory = false;
                    bw.write(this.lblMoth.getText());
                    bw.write(",");
                }
                if (this.lblOrb.isVisible()) {
                    emptyInventory = false;
                    bw.write(this.lblOrb.getText());
                    bw.write(",");
                }
                if (this.lblSilk.isVisible()) {
                    emptyInventory = false;
                    bw.write(this.lblSilk.getText());
                    bw.write(",");
                }
                if (this.lblForkedStick.isVisible()) {
                    emptyInventory = false;
                    bw.write(this.lblForkedStick.getText());
                    bw.write(",");
                }
                if (this.lblKettie.isVisible()) {
                    emptyInventory = false;
                    bw.write(this.lblKettie.getText());
                    bw.write(",");
                }
                if (this.lblMarble.isVisible()) {
                    emptyInventory = false;
                    bw.write(this.lblMarble.getText());
                    bw.write(",");
                }
                if (emptyInventory) {
                    bw.write("Empty");
                }
                bw.newLine();
                if (this.commands[4]) {
                    bw.write("true");
                } else {
                    bw.write("false");
                }
                bw.newLine();
                for (i = 0; i <= this.showLines.length - 1; ++i) {
                    if (!this.showLines[i]) continue;
                    bw.write(i + ",");
                }
                bw.newLine();
                bw.write(String.valueOf(this.getCanEndGame()));
                bw.newLine();
                bw.write(this.lblStatus.getText());
                bw.newLine();
                for (i = 0; i <= 6; ++i) {
                    for (int z = 0; z <= 6; ++z) {
                        if (!this.positionsVisited[i][z]) continue;
                        bw.write(i + "," + z);
                        bw.newLine();
                    }
                }
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
        saveGameFile.doQuery();
    }
}

