/*
 * Decompiled with CFR 0.152.
 */
package za.ac.mandela.wrpv301.UI;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javafx.application.Application;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import za.ac.mandela.wrpv301.Controllers.ForestVentureController;

public class UserInterface
extends Application {
    public void start(Stage primaryStage) {
        Stage gameStage = new Stage();
        gameStage.setTitle("Forest Venture");
        Stage aboutStage = new Stage();
        aboutStage.setTitle("Forest Venture");
        Scene startScene = this.createStartScene();
        Scene gameScene = this.createGameScene();
        Scene aboutScene = this.createAboutScene();
        ForestVentureController controller = new ForestVentureController();
        controller.connectToStartScene(startScene, gameScene, aboutScene, aboutStage, gameStage, primaryStage);
        controller.connectToGameScene(primaryStage, gameStage, aboutStage, startScene, gameScene, aboutScene);
        controller.connectToAboutScene(aboutScene);
        primaryStage.setScene(startScene);
        primaryStage.setTitle("Forest Venture");
        primaryStage.setMaximized(true);
        primaryStage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private Scene createGameScene() {
        BorderPane root = new BorderPane();
        root.setId("gameRoot");
        root.setTop((Node)this.heading());
        root.setBottom((Node)this.options());
        root.setLeft((Node)this.mapImage());
        root.setRight((Node)this.inventory());
        Label lblStatus = new Label();
        lblStatus.setId("lblStatus");
        VBox centerBox = new VBox();
        centerBox.setId("centerBox");
        centerBox.getChildren().addAll((Object[])new Node[]{this.description(), lblStatus});
        root.setCenter((Node)centerBox);
        FileInputStream input = null;
        try {
            input = new FileInputStream("ForestVenture/images/black_background.jpg");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        assert (input != null);
        Image image = new Image((InputStream)input);
        BackgroundImage backgroundImage = new BackgroundImage(image, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.DEFAULT, BackgroundSize.DEFAULT);
        Background background = new Background(new BackgroundImage[]{backgroundImage});
        root.setBackground(background);
        return new Scene((Parent)root);
    }

    private Scene createStartScene() {
        BorderPane startPane = new BorderPane();
        Label lblHeading = new Label("Forest Venture");
        lblHeading.setId("lblGameHeading");
        HBox menuBox = new HBox();
        menuBox.setId("menuBox");
        Button btnStartGame = new Button("New Game");
        btnStartGame.setId("btnStartGame");
        Button btnLoadGame = new Button("Load Game");
        btnLoadGame.setId("btnLoadGame");
        Button btnAbout = new Button("About");
        btnAbout.setId("btnAbout");
        menuBox.getChildren().addAll((Object[])new Node[]{btnStartGame, btnLoadGame, btnAbout});
        VBox root = new VBox();
        root.setId("mainRoot");
        root.getChildren().addAll((Object[])new Node[]{lblHeading, menuBox});
        startPane.setCenter((Node)root);
        FileInputStream input = null;
        try {
            input = new FileInputStream("ForestVenture/images/startupBackground.jpg");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        assert (input != null);
        Image image = new Image((InputStream)input);
        BackgroundImage backgroundImage = new BackgroundImage(image, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.DEFAULT, BackgroundSize.DEFAULT);
        Background background = new Background(new BackgroundImage[]{backgroundImage});
        startPane.setBackground(background);
        return new Scene((Parent)startPane);
    }

    private VBox inventory() {
        VBox inventoryBox = new VBox();
        inventoryBox.setId("inventoryBox");
        Label lblInventoryHeading = new Label();
        lblInventoryHeading.setId("lblInventoryHeading");
        Label lblMoth = new Label();
        lblMoth.setId("lblMoth");
        Label lblOrb = new Label();
        lblOrb.setId("lblOrb");
        Label lblSilk = new Label();
        lblSilk.setId("lblSilk");
        Label lblForkedStick = new Label();
        lblForkedStick.setId("lblForkedStick");
        Label lblKettie = new Label();
        lblKettie.setId("lblKettie");
        Label lblMarble = new Label();
        lblMarble.setId("lblMarble");
        inventoryBox.getChildren().addAll((Object[])new Node[]{lblInventoryHeading, lblMoth, lblOrb, lblSilk, lblForkedStick, lblKettie, lblMarble});
        return inventoryBox;
    }

    private VBox options() {
        VBox optionsBox = new VBox();
        optionsBox.setId("optionsBox");
        Label lblCommandInfo = new Label();
        lblCommandInfo.setId("lblCommandInfo");
        TextField txtCommand = new TextField();
        txtCommand.setId("txtCommand");
        Button btnEnterCommand = new Button();
        btnEnterCommand.setId("btnEnterCommand");
        Button btnSaveGame = new Button();
        btnSaveGame.setId("btnSaveGame");
        HBox commandBox = new HBox();
        commandBox.setId("commandBox");
        commandBox.getChildren().addAll((Object[])new Node[]{txtCommand, btnEnterCommand, btnSaveGame});
        optionsBox.getChildren().addAll((Object[])new Node[]{lblCommandInfo, commandBox});
        return optionsBox;
    }

    private TextArea description() {
        TextArea txaDescription = new TextArea();
        txaDescription.setId("txaDescription");
        return txaDescription;
    }

    private Label heading() {
        Label lblHeading = new Label();
        lblHeading.setId("lblHeading");
        return lblHeading;
    }

    private VBox mapImage() {
        GridPane mapPane = new GridPane();
        mapPane.setId("mapPane");
        Rectangle[][] rectangles = new Rectangle[7][7];
        Rectangle[][] copies = new Rectangle[7][7];
        for (int x = 0; x <= 6; ++x) {
            for (int y = 0; y <= 6; ++y) {
                copies[x][y] = new Rectangle();
                copies[x][y].setWidth(40.0);
                copies[x][y].setHeight(40.0);
                copies[x][y].setStyle("-fx-fill: #515151");
                GridPane.setHalignment((Node)copies[x][y], (HPos)HPos.CENTER);
                mapPane.add((Node)copies[x][y], y, x);
                rectangles[x][y] = new Rectangle();
                rectangles[x][y].setWidth(30.0);
                rectangles[x][y].setHeight(30.0);
                rectangles[x][y].setArcHeight(3.0);
                rectangles[x][y].setArcWidth(3.0);
                rectangles[x][y].setStyle("-fx-fill: #515151");
                GridPane.setHalignment((Node)rectangles[x][y], (HPos)HPos.CENTER);
                mapPane.add((Node)rectangles[x][y], y, x);
            }
        }
        Rectangle[] lines = new Rectangle[67];
        for (int i = 0; i <= lines.length - 1; ++i) {
            lines[i] = new Rectangle();
        }
        lines[0].setWidth(10.0);
        lines[0].setHeight(5.0);
        mapPane.add((Node)lines[0], 1, 6);
        GridPane.setValignment((Node)lines[0], (VPos)VPos.TOP);
        GridPane.setHalignment((Node)lines[0], (HPos)HPos.CENTER);
        lines[0].setId("line0");
        lines[1].setWidth(10.0);
        lines[1].setHeight(5.0);
        mapPane.add((Node)lines[1], 1, 5);
        GridPane.setValignment((Node)lines[1], (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)lines[1], (HPos)HPos.CENTER);
        lines[1].setId("line1");
        lines[2].setWidth(10.0);
        lines[2].setHeight(5.0);
        mapPane.add((Node)lines[2], 1, 5);
        GridPane.setValignment((Node)lines[2], (VPos)VPos.TOP);
        GridPane.setHalignment((Node)lines[2], (HPos)HPos.CENTER);
        lines[2].setId("line2");
        lines[3].setWidth(10.0);
        lines[3].setHeight(5.0);
        mapPane.add((Node)lines[3], 1, 4);
        GridPane.setValignment((Node)lines[3], (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)lines[3], (HPos)HPos.CENTER);
        lines[3].setId("line3");
        lines[4].setWidth(10.0);
        lines[4].setHeight(5.0);
        mapPane.add((Node)lines[4], 1, 4);
        GridPane.setValignment((Node)lines[4], (VPos)VPos.TOP);
        GridPane.setHalignment((Node)lines[4], (HPos)HPos.CENTER);
        lines[4].setId("line4");
        lines[5].setWidth(10.0);
        lines[5].setHeight(5.0);
        mapPane.add((Node)lines[5], 1, 3);
        GridPane.setValignment((Node)lines[5], (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)lines[5], (HPos)HPos.CENTER);
        lines[5].setId("line5");
        lines[6].setWidth(5.0);
        lines[6].setHeight(10.0);
        mapPane.add((Node)lines[6], 1, 3);
        GridPane.setHalignment((Node)lines[6], (HPos)HPos.LEFT);
        lines[6].setId("line6");
        lines[7].setWidth(5.0);
        lines[7].setHeight(10.0);
        mapPane.add((Node)lines[7], 0, 3);
        GridPane.setHalignment((Node)lines[7], (HPos)HPos.RIGHT);
        lines[7].setId("line7");
        lines[8].setWidth(5.0);
        lines[8].setHeight(10.0);
        mapPane.add((Node)lines[8], 1, 5);
        GridPane.setHalignment((Node)lines[8], (HPos)HPos.RIGHT);
        lines[8].setId("line8");
        lines[9].setWidth(5.0);
        lines[9].setHeight(10.0);
        mapPane.add((Node)lines[9], 2, 5);
        GridPane.setHalignment((Node)lines[9], (HPos)HPos.LEFT);
        lines[9].setId("line9");
        lines[10].setWidth(10.0);
        lines[10].setHeight(5.0);
        mapPane.add((Node)lines[10], 2, 5);
        GridPane.setValignment((Node)lines[10], (VPos)VPos.TOP);
        GridPane.setHalignment((Node)lines[10], (HPos)HPos.CENTER);
        lines[10].setId("line10");
        lines[11].setWidth(10.0);
        lines[11].setHeight(5.0);
        mapPane.add((Node)lines[11], 2, 4);
        GridPane.setValignment((Node)lines[11], (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)lines[11], (HPos)HPos.CENTER);
        lines[11].setId("line11");
        lines[12].setWidth(5.0);
        lines[12].setHeight(10.0);
        mapPane.add((Node)lines[12], 2, 4);
        GridPane.setHalignment((Node)lines[12], (HPos)HPos.RIGHT);
        lines[12].setId("line12");
        lines[13].setWidth(5.0);
        lines[13].setHeight(10.0);
        mapPane.add((Node)lines[13], 3, 4);
        GridPane.setHalignment((Node)lines[13], (HPos)HPos.LEFT);
        lines[13].setId("line13");
        lines[14].setWidth(10.0);
        lines[14].setHeight(5.0);
        mapPane.add((Node)lines[14], 3, 4);
        GridPane.setValignment((Node)lines[14], (VPos)VPos.TOP);
        GridPane.setHalignment((Node)lines[14], (HPos)HPos.CENTER);
        lines[14].setId("line14");
        lines[15].setWidth(10.0);
        lines[15].setHeight(5.0);
        mapPane.add((Node)lines[15], 3, 3);
        GridPane.setValignment((Node)lines[15], (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)lines[15], (HPos)HPos.CENTER);
        lines[15].setId("line15");
        lines[16].setWidth(5.0);
        lines[16].setHeight(10.0);
        mapPane.add((Node)lines[16], 3, 4);
        GridPane.setHalignment((Node)lines[16], (HPos)HPos.RIGHT);
        lines[16].setId("line16");
        lines[17].setWidth(5.0);
        lines[17].setHeight(10.0);
        mapPane.add((Node)lines[17], 4, 4);
        GridPane.setHalignment((Node)lines[17], (HPos)HPos.LEFT);
        lines[17].setId("line17");
        lines[18].setWidth(10.0);
        lines[18].setHeight(5.0);
        mapPane.add((Node)lines[18], 4, 4);
        GridPane.setValignment((Node)lines[18], (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)lines[18], (HPos)HPos.CENTER);
        lines[18].setId("line18");
        lines[19].setWidth(10.0);
        lines[19].setHeight(5.0);
        mapPane.add((Node)lines[19], 4, 5);
        GridPane.setValignment((Node)lines[19], (VPos)VPos.TOP);
        GridPane.setHalignment((Node)lines[19], (HPos)HPos.CENTER);
        lines[19].setId("line19");
        lines[20].setWidth(5.0);
        lines[20].setHeight(10.0);
        mapPane.add((Node)lines[20], 4, 5);
        GridPane.setHalignment((Node)lines[20], (HPos)HPos.LEFT);
        lines[20].setId("line20");
        lines[21].setWidth(5.0);
        lines[21].setHeight(10.0);
        mapPane.add((Node)lines[21], 3, 5);
        GridPane.setHalignment((Node)lines[21], (HPos)HPos.RIGHT);
        lines[21].setId("line21");
        lines[22].setWidth(5.0);
        lines[22].setHeight(10.0);
        mapPane.add((Node)lines[22], 4, 4);
        GridPane.setHalignment((Node)lines[22], (HPos)HPos.RIGHT);
        lines[22].setId("line22");
        lines[23].setWidth(5.0);
        lines[23].setHeight(10.0);
        mapPane.add((Node)lines[23], 5, 4);
        GridPane.setHalignment((Node)lines[23], (HPos)HPos.LEFT);
        lines[23].setId("line23");
        lines[24].setWidth(10.0);
        lines[24].setHeight(5.0);
        mapPane.add((Node)lines[24], 5, 4);
        GridPane.setValignment((Node)lines[24], (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)lines[24], (HPos)HPos.CENTER);
        lines[24].setId("line24");
        lines[25].setWidth(10.0);
        lines[25].setHeight(5.0);
        mapPane.add((Node)lines[25], 5, 5);
        GridPane.setValignment((Node)lines[25], (VPos)VPos.TOP);
        GridPane.setHalignment((Node)lines[25], (HPos)HPos.CENTER);
        lines[25].setId("line25");
        lines[26].setWidth(5.0);
        lines[26].setHeight(10.0);
        mapPane.add((Node)lines[26], 5, 5);
        GridPane.setHalignment((Node)lines[26], (HPos)HPos.RIGHT);
        lines[26].setId("line26");
        lines[27].setWidth(5.0);
        lines[27].setHeight(10.0);
        mapPane.add((Node)lines[27], 6, 5);
        GridPane.setHalignment((Node)lines[27], (HPos)HPos.LEFT);
        lines[27].setId("line27");
        lines[28].setWidth(5.0);
        lines[28].setHeight(10.0);
        mapPane.add((Node)lines[28], 2, 1);
        GridPane.setHalignment((Node)lines[28], (HPos)HPos.RIGHT);
        lines[28].setId("line28");
        lines[29].setWidth(5.0);
        lines[29].setHeight(10.0);
        mapPane.add((Node)lines[29], 3, 1);
        GridPane.setHalignment((Node)lines[29], (HPos)HPos.LEFT);
        lines[29].setId("line29");
        lines[30].setWidth(10.0);
        lines[30].setHeight(5.0);
        mapPane.add((Node)lines[30], 3, 1);
        GridPane.setValignment((Node)lines[30], (VPos)VPos.TOP);
        GridPane.setHalignment((Node)lines[30], (HPos)HPos.CENTER);
        lines[30].setId("line30");
        lines[31].setWidth(10.0);
        lines[31].setHeight(5.0);
        mapPane.add((Node)lines[31], 3, 0);
        GridPane.setValignment((Node)lines[31], (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)lines[31], (HPos)HPos.CENTER);
        lines[31].setId("line31");
        lines[32].setWidth(5.0);
        lines[32].setHeight(10.0);
        mapPane.add((Node)lines[32], 3, 0);
        GridPane.setHalignment((Node)lines[32], (HPos)HPos.RIGHT);
        lines[32].setId("line32");
        lines[33].setWidth(5.0);
        lines[33].setHeight(10.0);
        mapPane.add((Node)lines[33], 4, 0);
        GridPane.setHalignment((Node)lines[33], (HPos)HPos.LEFT);
        lines[33].setId("line33");
        lines[34].setWidth(10.0);
        lines[34].setHeight(5.0);
        mapPane.add((Node)lines[34], 4, 0);
        GridPane.setValignment((Node)lines[34], (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)lines[34], (HPos)HPos.CENTER);
        lines[34].setId("line34");
        lines[35].setWidth(10.0);
        lines[35].setHeight(5.0);
        mapPane.add((Node)lines[35], 4, 1);
        GridPane.setValignment((Node)lines[35], (VPos)VPos.TOP);
        GridPane.setHalignment((Node)lines[35], (HPos)HPos.CENTER);
        lines[35].setId("line35");
        lines[36].setWidth(10.0);
        lines[36].setHeight(5.0);
        mapPane.add((Node)lines[36], 0, 3);
        GridPane.setValignment((Node)lines[36], (VPos)VPos.TOP);
        GridPane.setHalignment((Node)lines[36], (HPos)HPos.CENTER);
        lines[36].setId("line36");
        lines[37].setWidth(10.0);
        lines[37].setHeight(25.0);
        mapPane.add((Node)lines[37], 0, 2);
        GridPane.setValignment((Node)lines[37], (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)lines[37], (HPos)HPos.CENTER);
        lines[37].setId("line37");
        lines[38].setWidth(10.0);
        lines[38].setHeight(5.0);
        mapPane.add((Node)lines[38], 2, 1);
        GridPane.setValignment((Node)lines[38], (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)lines[38], (HPos)HPos.CENTER);
        lines[38].setId("line38");
        lines[39].setWidth(10.0);
        lines[39].setHeight(25.0);
        mapPane.add((Node)lines[39], 2, 2);
        GridPane.setValignment((Node)lines[39], (VPos)VPos.TOP);
        GridPane.setHalignment((Node)lines[39], (HPos)HPos.CENTER);
        lines[39].setId("line39");
        lines[40].setWidth(35.0);
        lines[40].setHeight(10.0);
        mapPane.add((Node)lines[40], 1, 2);
        GridPane.setValignment((Node)lines[40], (VPos)VPos.CENTER);
        lines[40].setId("line40");
        lines[41].setWidth(20.0);
        lines[41].setHeight(10.0);
        mapPane.add((Node)lines[41], 0, 2);
        GridPane.setHalignment((Node)lines[41], (HPos)HPos.RIGHT);
        lines[41].setId("line41");
        lines[42].setWidth(5.0);
        lines[42].setHeight(10.0);
        mapPane.add((Node)lines[42], 1, 2);
        GridPane.setHalignment((Node)lines[42], (HPos)HPos.RIGHT);
        lines[42].setId("line42");
        lines[43].setWidth(25.0);
        lines[43].setHeight(10.0);
        mapPane.add((Node)lines[43], 2, 2);
        GridPane.setHalignment((Node)lines[43], (HPos)HPos.LEFT);
        lines[43].setId("line43");
        lines[44].setWidth(40.0);
        lines[44].setHeight(10.0);
        mapPane.add((Node)lines[44], 2, 6);
        GridPane.setHalignment((Node)lines[44], (HPos)HPos.CENTER);
        lines[44].setId("line44");
        lines[45].setWidth(5.0);
        lines[45].setHeight(10.0);
        mapPane.add((Node)lines[45], 1, 6);
        GridPane.setHalignment((Node)lines[45], (HPos)HPos.RIGHT);
        lines[45].setId("line45");
        lines[46].setWidth(40.0);
        lines[46].setHeight(10.0);
        mapPane.add((Node)lines[46], 3, 6);
        GridPane.setHalignment((Node)lines[46], (HPos)HPos.CENTER);
        lines[46].setId("line46");
        lines[47].setWidth(10.0);
        lines[47].setHeight(25.0);
        mapPane.add((Node)lines[47], 4, 6);
        GridPane.setValignment((Node)lines[47], (VPos)VPos.TOP);
        GridPane.setHalignment((Node)lines[47], (HPos)HPos.CENTER);
        lines[47].setId("line47");
        lines[48].setWidth(25.0);
        lines[48].setHeight(10.0);
        mapPane.add((Node)lines[48], 4, 6);
        GridPane.setHalignment((Node)lines[48], (HPos)HPos.LEFT);
        lines[48].setId("line48");
        lines[49].setWidth(10.0);
        lines[49].setHeight(5.0);
        mapPane.add((Node)lines[49], 4, 5);
        GridPane.setValignment((Node)lines[49], (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)lines[49], (HPos)HPos.CENTER);
        lines[49].setId("line49");
        lines[50].setWidth(10.0);
        lines[50].setHeight(5.0);
        mapPane.add((Node)lines[50], 6, 5);
        GridPane.setValignment((Node)lines[50], (VPos)VPos.TOP);
        GridPane.setHalignment((Node)lines[50], (HPos)HPos.CENTER);
        lines[50].setId("line50");
        lines[51].setWidth(10.0);
        lines[51].setHeight(40.0);
        mapPane.add((Node)lines[51], 6, 4);
        GridPane.setValignment((Node)lines[51], (VPos)VPos.CENTER);
        GridPane.setHalignment((Node)lines[51], (HPos)HPos.CENTER);
        lines[51].setId("line51");
        lines[52].setWidth(10.0);
        lines[52].setHeight(40.0);
        mapPane.add((Node)lines[52], 6, 3);
        GridPane.setValignment((Node)lines[52], (VPos)VPos.CENTER);
        GridPane.setHalignment((Node)lines[52], (HPos)HPos.CENTER);
        lines[52].setId("line52");
        lines[53].setWidth(10.0);
        lines[53].setHeight(40.0);
        mapPane.add((Node)lines[53], 6, 2);
        GridPane.setValignment((Node)lines[53], (VPos)VPos.CENTER);
        GridPane.setHalignment((Node)lines[53], (HPos)HPos.CENTER);
        lines[53].setId("line53");
        lines[54].setWidth(10.0);
        lines[54].setHeight(25.0);
        mapPane.add((Node)lines[54], 6, 1);
        GridPane.setValignment((Node)lines[54], (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)lines[54], (HPos)HPos.CENTER);
        lines[54].setId("line54");
        lines[55].setWidth(40.0);
        lines[55].setHeight(10.0);
        mapPane.add((Node)lines[55], 5, 1);
        GridPane.setHalignment((Node)lines[55], (HPos)HPos.CENTER);
        lines[55].setId("line55");
        lines[56].setWidth(20.0);
        lines[56].setHeight(10.0);
        mapPane.add((Node)lines[56], 6, 1);
        GridPane.setHalignment((Node)lines[56], (HPos)HPos.LEFT);
        lines[56].setId("line56");
        lines[57].setWidth(5.0);
        lines[57].setHeight(10.0);
        mapPane.add((Node)lines[57], 4, 1);
        GridPane.setHalignment((Node)lines[57], (HPos)HPos.RIGHT);
        lines[57].setId("line57");
        lines[58].setWidth(10.0);
        lines[58].setHeight(5.0);
        mapPane.add((Node)lines[58], 5, 4);
        GridPane.setHalignment((Node)lines[58], (HPos)HPos.CENTER);
        GridPane.setValignment((Node)lines[58], (VPos)VPos.TOP);
        lines[58].setId("line58");
        lines[59].setWidth(10.0);
        lines[59].setHeight(25.0);
        mapPane.add((Node)lines[59], 5, 3);
        GridPane.setHalignment((Node)lines[59], (HPos)HPos.CENTER);
        GridPane.setValignment((Node)lines[59], (VPos)VPos.BOTTOM);
        lines[59].setId("line59");
        lines[60].setWidth(25.0);
        lines[60].setHeight(10.0);
        mapPane.add((Node)lines[60], 5, 3);
        GridPane.setHalignment((Node)lines[60], (HPos)HPos.LEFT);
        lines[60].setId("line60");
        lines[61].setWidth(25.0);
        lines[61].setHeight(10.0);
        mapPane.add((Node)lines[61], 4, 3);
        GridPane.setHalignment((Node)lines[61], (HPos)HPos.RIGHT);
        lines[61].setId("line61");
        lines[62].setWidth(10.0);
        lines[62].setHeight(25.0);
        mapPane.add((Node)lines[62], 4, 3);
        GridPane.setHalignment((Node)lines[62], (HPos)HPos.CENTER);
        GridPane.setValignment((Node)lines[62], (VPos)VPos.BOTTOM);
        lines[62].setId("line62");
        lines[63].setWidth(10.0);
        lines[63].setHeight(5.0);
        mapPane.add((Node)lines[63], 4, 4);
        GridPane.setHalignment((Node)lines[63], (HPos)HPos.CENTER);
        GridPane.setValignment((Node)lines[63], (VPos)VPos.TOP);
        lines[63].setId("line63");
        lines[64].setWidth(10.0);
        lines[64].setHeight(5.0);
        mapPane.add((Node)lines[64], 3, 1);
        GridPane.setHalignment((Node)lines[64], (HPos)HPos.CENTER);
        GridPane.setValignment((Node)lines[64], (VPos)VPos.BOTTOM);
        lines[64].setId("line64");
        lines[65].setWidth(10.0);
        lines[65].setHeight(40.0);
        mapPane.add((Node)lines[65], 3, 2);
        GridPane.setHalignment((Node)lines[65], (HPos)HPos.CENTER);
        GridPane.setValignment((Node)lines[65], (VPos)VPos.CENTER);
        lines[65].setId("line65");
        lines[66].setWidth(10.0);
        lines[66].setHeight(5.0);
        mapPane.add((Node)lines[66], 3, 3);
        GridPane.setHalignment((Node)lines[66], (HPos)HPos.CENTER);
        GridPane.setValignment((Node)lines[66], (VPos)VPos.TOP);
        lines[66].setId("line66");
        Circle friendPosition = new Circle();
        friendPosition.setId("friendPosition");
        mapPane.add((Node)friendPosition, 4, 1);
        try {
            FileInputStream inputStreamPlayer = new FileInputStream("ForestVenture/images/player_north.png");
            Image image = new Image((InputStream)inputStreamPlayer);
            ImageView player = new ImageView(image);
            player.setId("player");
            mapPane.add((Node)player, 1, 6);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            FileInputStream inputStreamHome = new FileInputStream("ForestVenture/images/home.png");
            Image image = new Image((InputStream)inputStreamHome);
            ImageView home = new ImageView(image);
            home.setId("home");
            mapPane.add((Node)home, 4, 1);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        rectangles[6][1].setId("1");
        rectangles[5][1].setId("2");
        rectangles[4][1].setId("3");
        rectangles[5][2].setId("4");
        rectangles[4][2].setId("5");
        rectangles[3][1].setId("6");
        rectangles[4][3].setId("7");
        rectangles[3][0].setId("8");
        rectangles[4][4].setId("9");
        rectangles[4][5].setId("10");
        rectangles[3][3].setId("11");
        rectangles[1][2].setId("12");
        rectangles[1][3].setId("13");
        rectangles[0][3].setId("14");
        rectangles[0][4].setId("15");
        rectangles[1][4].setId("16");
        rectangles[5][6].setId("17");
        rectangles[5][5].setId("18");
        rectangles[5][4].setId("19");
        rectangles[5][3].setId("20");
        VBox mapImageBox = new VBox();
        mapImageBox.setId("mapImageBox");
        mapImageBox.getChildren().addAll((Object[])new Node[]{mapPane});
        return mapImageBox;
    }

    private Scene createAboutScene() {
        BorderPane root = new BorderPane();
        root.setId("aboutRoot");
        Label lblAboutHeading = new Label();
        lblAboutHeading.setId("lblAboutHeading");
        VBox commandInfoBox = new VBox();
        commandInfoBox.setId("commandInfoBox");
        Label lblAboutGame = new Label();
        lblAboutGame.setId("lblAboutGame");
        Label lblCommandsInfo = new Label();
        lblCommandsInfo.setId("lblCommandsInfo");
        Label lblPlagiarism = new Label();
        lblPlagiarism.setId("lblPlagiarism");
        commandInfoBox.getChildren().addAll((Object[])new Node[]{lblAboutGame, lblCommandsInfo, lblPlagiarism});
        Label lblCreator = new Label();
        lblCreator.setId("lblCreator");
        root.setTop((Node)lblAboutHeading);
        root.setCenter((Node)commandInfoBox);
        root.setBottom((Node)lblCreator);
        FileInputStream input = null;
        try {
            input = new FileInputStream("ForestVenture/images/black_background.jpg");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        assert (input != null);
        Image image = new Image((InputStream)input);
        BackgroundImage backgroundImage = new BackgroundImage(image, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.DEFAULT, BackgroundSize.DEFAULT);
        Background background = new Background(new BackgroundImage[]{backgroundImage});
        root.setBackground(background);
        return new Scene((Parent)root);
    }
}

